From jsevinsk@spd.dsccc.com Wed Nov 29 10:22:40 1995
In article <8B5D44A.0294001240.uuout@atlpcug.org>,
LEWIS MOSELEY <lewis.moseley@atlpcug.org> wrote:
>A standard mini-controller will work only on unit codes 1-4 or 5-8.  I
>have lots of midules and would like to use a mini-controller to control
>unit codes 9-12 and 13-16.  Does anybody make a mini-controller  that
>will do this, or can a "standard" mini be modified to do so?

Yes!  Here's how:

------------------------------------------------------------------------------

From: felix.filenet.com!dennisg (Dennis Griesser)
Date: Mon, 4 May 92 21:58:50 PDT
Subject: hacking the mini controller for all 16 units

              CONVERTING THE X-10 MINI CONTROLLER FOR 4 BANDS

by Dennis Griesser, 04/22/92
   dennisg@filenet.com
   ...uunet!felix!dennisg
   ...hplabs!felix!dennisg

This document may be freely distributed, so long at the attributions are kept
intact.


INTRODUCTION

The X-10 mini controller is capable of addressing four of the sixteen X-10
unit codes.  A slide switch on the controller allows the user to select the
"band" of units 1-4 or 5-8.  A simple modification allows the selection of two
additional bands, 9-12 and 13-16.  This covers the entire spectrum of X-10
units accessible from a single house-code.


APPLICABLE HARDWARE

This modification applies to the "Radio Shack" branded mini controller, number
61-2677B.  By visual inspection of the circuit board and internal components,
it appears that this modification also applies to "Stanley" branded mini
controller number 360-3090.  It appears that both of these units were
manufactured for X-10 for sale under the distributers' own brand name, and are
essentially identical inside.

There was an earlier model of the mini controller that was available from
Radio Shack, and possibly other sources.  Legend has it that the old unit was
even easier to modify for access to all four bands.  In fact, one legend says
that the unit was equipped with a four-band switch, two positions of which
were simply blocked off by the plastic bezel sticker applied over the plastic
cabinet.  I don't know what the truth is, not having one of the old mini
controllers to study.  What I do know is that this modification was not
developed for the old controller.

The old mini controller had four switches for the unit codes, plus individual
switches for ON, OFF, DIM, BRIGHT, ALL LIGHTS ON, and ALL UNITS OFF.  To turn
on unit three, one would depress two switches:  3 and ON.

The new mini controller does not have ON and OFF switches apart from the unit
codes. Instead it has an ON and OFF switch for each of the four unit codes.
(In the case of the Radio Shack unit, there are four rocker switches, up for ON
and down for OFF.  The Stanley unit has individual switches for 1 ON, 1 OFF,
2 ON, 2 OFF, etc.)  Pressing one of these switches sends both the unit code and
the ON or OFF command.  The user can then follow up by using the DIM or BRIGHT
switches, or the ALL LIGHTS ON or ALL UNITS OFF switches.


DISCLAIMER

In no case do I take any responsibility whatsoever from any results that might
come out of your attempts to perform this modification.  Use your own good
sense and normal safety precautions in dealing with the hazardous voltages
inside the controller.

I have misplaced the notes that I made when I originally came up with this
modification,  tinkering around with the insides of the mini controller.  This
document was the result of one evening of reverse-engineering my previous
efforts.  I have one that works, and I hope that I got it all written down
here in a fashion that others can duplicate.


GETTING STARTED

Unplug the unit and open the case by removing the four phillips-head screws. 
Put both halves of the case in a safe place.  When handling the printed
circuit board, orbserve the usual precautions for static-sensitive devices.

Locate the place where the existing "band" switch is located.  This is nothing
more than a plastic handle on a metal slider that runs in a trough molded into
the top part of the case.  The slider makes contact with three large pads on 
the printed circuit board.

The hardest part of the modification is finding a new switch to use for the
four-position band selector!  It is possible to use a two-pole four-throw
rotary switch.  I'll let you figure out how to do the encoding if you
decide on that.  I found a suitable switch in my junk-box and mounted it in a
position that replaces the old band switch.  This entailed some amount of
cutting and gluing on the plastic case.  I will assume that you are doing the
same.

Find a small slide switch that has four positions.  It should have two rows of
five contacts.  As the switch is moved, it should short two adjacent contacts
at a time.  Looking into the pins in the back of the switch, one should see the
following connection pattern for each switch position:
     position 1         position 2         position 3         position 4
   +-------------+    +-------------+    +-------------+    +-------------+
   |1--2  3  4  5|    |1  2--3  4  5|    |1  2  3--4  5|    |1  2  3  4--5|
   |             |    |             |    |             |    |             |
   |A--B  C  D  E|    |A  B--C  D  E|    |A  B  C--D  E|    |A  B  C  D--E|
   +-------------+    +-------------+    +-------------+    +-------------+

Physically, the switch should fit in pleasingly with the rest of the panel. 
This usually means that it should be rather small.  This is a good time to
decide exactly where to put it.  The most logical place is directly in place
of the existing band switch.  This may require hacking away part of the
printed circuit board.

Orient the printed circuit board in front of you, such that the foil side is
down, and the power cord attaches to the board on your left.  The big chip
should be slightly right of center, and most of the components will be near
your belly.  Make sure that the chip has 24 pins, and is marked 78567.  To
your right of the chip is a small metal-can transformer.  Further right and
up, should be an electrolytic capacitor, around 1000 mFd at 25 V.  The
capacitor's negative lead is well marked.  Locate the positive lead.


CONNECTIONS

If the new switch does not physically replace the old one, disable the old
switch by removing the slider from it.

Looking into the back of the switch, wire pin A to 4 to IC pin 11.  Wire
switch pin B to 3 to D to the + lead of the capacitor.  Wire switch pin C to
IC pin 12.  The result should look something like this:
      .------------.
      |            |
      |  +---------|---+
      |  |1  2 _3_ 4  5|
      |  |    /   \    |
      |---A  B  C  D  E|
      |  +------|--|---+
      |         |  |
      |         |  `-----> to capacitor +
      |         `--------> to IC, pin 12
      `------------------> to IC, pin 11


The intent of this circuit is to impress one of four binary codes on the IC's
pins 11 and 12.  This tells the controller chip which band of X-10 units to
address.  The logic levels to be presented to the chip are provided by dead
air and the + lead of the electrolytic capacitor.  The truth table is:
   unit     switch     switch    |  pin 11   pin 12
   band     position   shorting  |  sees     sees
   -----    --------   -------- -+- ------   -----
    1-4        1       1&2, A&B  |  cap      air
    5-8        2       2&3, B&C  |  air      cap
    9-12       3       3&4, C&D  |  cap      cap
   13-15       4       4&5, D&E  |  air      air


ROTARY SWITCH OPTION

This version is untested, but should work.  It is for rotary switch lovers out
there.  Get a 2-pole 4-throw rotary switch and wire it as follows:
        .------------------------------> to capacitor +
        |     |              |  |    
        1_ 2  3  4        1_ 2  3  4
        |\                |\
          \- - - - - - - - -\
           \                 \
            O                 O
            |                 |
            |                 `--------> to IC, pin 12
            `--------------------------> to IC, pin 11

You probably want to avoid binary or BCD-encoded thumbwheel switches because
the base station coding scheme is offset slightly from normal binary coding
(and the switch output).  You would have to relabel the switch positions, not
to mention blocking off the unused positions.


COMPLETION

Put the box back together.  Screw it shut again before applying power.

Try it out.





------------------------------------------------------------------------------
John Sevinsky, Software Geek          Work:  jsevinsk@spd.dsccc.com
DSC Communications Corporation        Home:  jsevinsk@airmail.net
But, I speak for myself, not DSC             http://www.airmail.net/~jsevinsk

