//***************************************************************************
//
// ZipDrop.h
//
//***************************************************************************

DEFINE_GUID (CLSID_ShellExtension, 0x8e4e0f0a, 0x0f1a, 0x11aa, 0xbc, 0xb0,
    0x11, 0xfd, 0x0e, 0x25, 0x42, 0x6c);

/////////////////////////////////////////////////////////////////////////////
// Classes

class CClassFactory : public IClassFactory
{
protected:
    ULONG m_cRef;
    
public:
    CClassFactory ();
    ~CClassFactory ();
        
    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID*);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
    
    // IClassFactory methods
    STDMETHODIMP CreateInstance (LPUNKNOWN, REFIID, LPVOID*);
    STDMETHODIMP LockServer (BOOL);
};

class CShellExtension : public IDropTarget, IPersistFile
{
protected:
    ULONG   m_cRef;
    char    m_szFile[MAX_PATH];
    BOOL    m_bFormatSupported;
    BOOL    m_bRightDrag;

    BOOL ZipFiles (STGMEDIUM*, BOOL, BOOL);

public:
    CShellExtension ();
    ~CShellExtension ();
    
    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID*);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
    
    // IDropTarget methods
    STDMETHODIMP DragEnter (IDataObject*, DWORD, POINTL, DWORD*);
    STDMETHODIMP DragOver (DWORD, POINTL, DWORD*);
    STDMETHODIMP DragLeave ();
    STDMETHODIMP Drop (IDataObject*, DWORD, POINTL, DWORD*);

    // IPersistFile methods
    STDMETHODIMP GetClassID (LPCLSID);
    STDMETHODIMP IsDirty ();
    STDMETHODIMP Load (LPCOLESTR, DWORD);
    STDMETHODIMP Save (LPCOLESTR, BOOL);
    STDMETHODIMP SaveCompleted (LPCOLESTR);
    STDMETHODIMP GetCurFile (LPOLESTR FAR *);
};
