//***************************************************************************
//
// ZipView.h
//
//***************************************************************************

DEFINE_GUID (CLSID_ShellExtension, 0x8e3e0f0a, 0x0f1a, 0x11aa, 0xbc, 0xb0,
    0xb3, 0xfd, 0x0e, 0x25, 0x38, 0x1a);

/////////////////////////////////////////////////////////////////////////////
// Structures

typedef struct tagLOCALFILEHEADER {
    DWORD   lfhSignature;               // 0x04034B50
    WORD    lfhVerToExtract;
    WORD    lfhFlag;
    WORD    lfhMethod;
    WORD    lfhTime;
    WORD    lfhDate;
    DWORD   lfhCrc;
    DWORD   lfhSizeCompressed;
    DWORD   lfhSizeUncompressed;
    WORD    lfhFileNameLength;
    WORD    lfhExtraLength;
} LOCALFILEHEADER, *PLOCALFILEHEADER;

typedef struct tagFILEHEADER {
    DWORD   fhSignature;                // 0x02014B50
    WORD    fhVerMadeBy;
    WORD    fhVerToExtract;
    WORD    fhFlag;
    WORD    fhMethod;
    WORD    fhTime;
    WORD    fhDate;
    DWORD   fhCrc;
    DWORD   fhSizeCompressed;
    DWORD   fhSizeUncompressed;
    WORD    fhFileNameLength;
    WORD    fhExtraLength;
    WORD    fhCommentLength;
    WORD    fhDiskStart;
    WORD    fhAttrInternal;
    DWORD   fhAttrExternal;
    DWORD   fhOffset;
} FILEHEADER, *PFILEHEADER;

typedef struct tagZIPFILEINFO {
    char    zfiFileName[MAX_PATH];
    WORD    zfiDate;
    WORD    zfiTime;
    DWORD   zfiSizeCompressed;
    DWORD   zfiSizeUncompressed;
    WORD    zfiMethod;
    DWORD   zfiCrc;
} ZIPFILEINFO, *PZIPFILEINFO;

/////////////////////////////////////////////////////////////////////////////
// Classes

class CClassFactory : public IClassFactory
{
protected:
    ULONG m_cRef;
    
public:
    CClassFactory ();
    ~CClassFactory ();
        
    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID*);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
    
    // IClassFactory methods
    STDMETHODIMP CreateInstance (LPUNKNOWN, REFIID, LPVOID*);
    STDMETHODIMP LockServer (BOOL);
};

class CShellExtension : public IShellPropSheetExt, IShellExtInit
{
protected:
    ULONG   m_cRef;
    char    m_szFile[MAX_PATH];

public:
    CShellExtension ();
    ~CShellExtension ();
    
    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID*);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
    
    // IShellPropSheetExt methods
    STDMETHODIMP AddPages (LPFNADDPROPSHEETPAGE, LPARAM);
    STDMETHODIMP ReplacePage (UINT, LPFNADDPROPSHEETPAGE, LPARAM);

    // IShellExtInit method
    STDMETHODIMP Initialize (LPCITEMIDLIST, LPDATAOBJECT, HKEY);
};
